                       /* BLW-INT1.PRO */
bw :-
  dialog([(ht, ti), (kb, ki), (gb, ti), (ki, ti), (de, gb)]).
  
dialog(Zustand) :-
  zeigt(Zustand), 
  ermittelt(Befehlsinhalt),
  ausgefuehrt(Befehlsinhalt, Zustand, Neuzustand), !,
  dialog(Neuzustand).
dialog(_) :-
  nl, write('Dialog beendet. Drcken Sie eine Taste!'),
  nl, get0(_).
    
zeigt(Liste) :-
  write('A k t u e l l e r  Z u s t a n d :'), nl,
  element(Objektpaar, Liste), erzeugt(Objektpaar, Satz),
  schreibt(Satz), nl, fail.
zeigt(_) :- nl.

schreibt([]).
schreibt([Wort| Satzrest]) :-
  write(Wort), write(' '), schreibt(Satzrest).

ermittelt(Objektpaar) :-
  write('Geben Sie eine Anweisung ein, und zwar in der Form:'), nl,
  write('[lege, den, '), put(39), write('Hut'), put(39), 
  write(', auf, das, kleine, '), put(39), write('Buch'),
  put(39), write('].'), nl,
  write('(Dialogende durch Eingabe von e.)'), nl,
  write('>>> '), read(Anweisung), write(Anweisung), nl,    
  versteht(Anweisung, Objektpaar). 

/* Semantik der Beschreibungssprache */

erzeugt((Obj, Ziel), Satz) :-
  unbeweglich(Obj),
  aussage(s(np(n(Obj)), vp(steht, pp(np(n(Ziel))))), Satz, []).
erzeugt((Obj, Ziel), Satz) :-
  not unbeweglich(Obj),
  aussage(s(np(n(Obj)), vp(liegt, pp(np(n(Ziel))))), Satz, []).
  
/* Semantik der Befehlssprache */

versteht(e, _) :- !, fail.
versteht(Satz, (Obj, Ziel)) :-
  befehl(s(np(n(Obj)), pp(np(n(Ziel)))), Satz, []),  
  not unbestimmt(Obj), not unbestimmt(Ziel),
  write('Satz verstanden ... '), !. 
versteht(Satz, Paar) :-
  befehl(s(np(n(Obj)), _), Satz, []),
  unbestimmt(Obj),  
  write('Welches Objekt ist gemeint? Wiederholen Sie die Eingabe!'), nl,
  write('>>> '), read(Befehl), write(Befehl), nl, !,
  versteht(Befehl, Paar).
versteht(Satz, Paar) :-
  befehl(s(_, pp(np(n(Ziel)))), Satz, []),
  unbestimmt(Ziel),  
  write('Welches Ziel ist gemeint? Wiederholen Sie die Eingabe!'), nl,
  write('>>> '), read(Befehl), write(Befehl), nl, !,
  versteht(Befehl, Paar).
versteht(Satz, Paar) :-
  befehl(s(np(n(Obj)), pp(np(n(Ziel)))), Satz, []),
  unbestimmt(Obj), unbestimmt(Ziel),  
  write('Objekt und Ziel sind unbestimmt. Bitte neue Eingabe!'), nl,
  write('>>> '), read(Befehl), write(Befehl), nl, !,
  versteht(Befehl, Paar).
versteht(_, Paar) :-
  write('Satz unverstndlich - versuchen Sie es noch einmal!'), nl,
  write('>>> '), read(Befehl), write(Befehl), nl, !, 
  versteht(Befehl, Paar).
  
/* Syntax der Befehlssprache */

befehl(s(NP, PP), Liste, Rest) :-
  imperativ(Liste, Rest1),
  nominalphrase(NP, Rest1, Rest2, akk, _),
  praepositionalphrase(PP, Rest2, Rest, akk).
befehl(s(NP, PP), Liste, Rest) :-
  imperativ(Liste, Rest1),
  praepositionalphrase(PP, Rest1, Rest2, akk),
  nominalphrase(NP, Rest2, Rest, akk, _).
  
aussage(s(NP, VP), Liste, Rest) :-
  nominalphrase(NP, Liste, Rest1, nom, _),
  verbalphrase(VP, Rest1, Rest).

verbalphrase(vp(V, PP), Liste, Rest) :-
  indikativ(V, Liste, Rest1),
  praepositionalphrase(PP, Rest1, Rest, dat).  

nominalphrase(np(n(N)), Liste, Rest, Kasus, Praep) :-
  artikel(Liste, Rest1, Kasus, Genus),
  nomen(N, Rest1, Rest, Genus, Praep).
nominalphrase(np(n(AN)), Liste, Rest, Kasus, Praep) :-
  artikel(Liste, Rest1, Kasus, Genus),
  adjektiv(Adj, Rest1, Rest2, Kasus, Genus),
  nomen(N, Rest2, Rest, Genus, Praep),
  zusammengefasst(Adj, N, AN).
  
zusammengefasst(Atom1, Atom2, Atom) :-
  name(Atom1, [X]), name(Atom2, [Y, _]),
  name(Atom, [X, Y]).
  
praepositionalphrase(pp(NP), Liste, Rest, Kasus) :-  
  praeposition(Praep, Liste, Rest1),
  nominalphrase(NP, Rest1, Rest, Kasus, Praep).

imperativ([lege    | Rest], Rest).
imperativ([stelle  | Rest], Rest).
imperativ([setze   | Rest], Rest).
imperativ([plaziere| Rest], Rest).
imperativ([bewege  | Rest], Rest).

indikativ(liegt, [liegt| Rest], Rest).
indikativ(steht, [steht| Rest], Rest).

artikel([der| Rest], Rest, nom, m).
artikel([die| Rest], Rest, nom, f).
artikel([das| Rest], Rest, nom, n).
artikel([dem| Rest], Rest, dat, m).
artikel([der| Rest], Rest, dat, f).
artikel([dem| Rest], Rest, dat, n).
artikel([den| Rest], Rest, akk, m).
artikel([die| Rest], Rest, akk, f).
artikel([das| Rest], Rest, akk, n).

adjektiv(k, [kleine | Rest], Rest, nom, G).
adjektiv(k, [kleinen| Rest], Rest, dat, G).
adjektiv(k, [kleinen| Rest], Rest, akk, m).
adjektiv(k, [kleine | Rest], Rest, akk, f).
adjektiv(k, [kleine | Rest], Rest, akk, n).

adjektiv(g, ['groe' | Rest], Rest, nom, G).
adjektiv(g, ['groen'| Rest], Rest, dat, G).
adjektiv(g, ['groen'| Rest], Rest, akk, m).
adjektiv(g, ['groe' | Rest], Rest, akk, f).
adjektiv(g, ['groe' | Rest], Rest, akk, n).

nomen(ht, ['Hut'  | Rest], Rest, m, on).
nomen(ti, ['Tisch'| Rest], Rest, m, on).
nomen(de, ['Decke'| Rest], Rest, f, un).
nomen(ki, ['Kiste'| Rest], Rest, f, in).
nomen(bu, ['Buch' | Rest], Rest, n, on).

praeposition(in, [in   | Rest], Rest).
praeposition(on, [auf  | Rest], Rest).
praeposition(un, [unter| Rest], Rest).

/* Befehlsausfhrung */

ausgefuehrt((Obj, Ziel), Liste, Neuliste) :-
  ersetzt((Obj, _), (Obj, Ziel), Liste, Neuliste),
  verschieden(Liste, Neuliste), 
  zulaessig(Neuliste),
  write('Bewegung ausgefhrt.'), nl, nl, !.
ausgefuehrt(_, Liste, Liste) :-
  write('Es wurde keine Bewegung ausgefhrt.'), nl, nl.
  
verschieden(Liste1, Liste2) :-
  Liste1 \= Liste2, !.
verschieden(_, _) :-
  write('Diese Operation bewirkt nichts.'), nl, fail.
  
zulaessig(X) :-
  irreflexiv(X),
  einfachbelegt(X),
  ungestapelt(X),
  belastbar(X),
  beweglich(X),
  vertraeglich(X).

/* Zustandsbedingungen */

irreflexiv(Liste) :-
  element((X, X), Liste), write('Geht nicht!'), nl,
  write('Die Objekte mssen verschieden sein.'), nl, !, fail.
irreflexiv(_).

einfachbelegt(Liste) :-
  element((X, Z), Liste), element((Y, Z), Liste), X \= Y, Z \= ti, 
  write('So nicht!'), nl, write('Zwei Objekte '),
  write('drfen nicht das gleiche Ziel haben.'), nl, !, fail.
einfachbelegt(_).

ungestapelt(Liste) :-
  element((X, Y), Liste), element((Y, Z), Liste), Z \= ti,
  write('Tut mir leid!'), nl, write('Die Objekte '),
  write('drfen nicht gestapelt werden.'), nl, !, fail.
ungestapelt(_).
  
belastbar(Liste) :-
  unbelastbar(X), element((_, X), Liste),  
  write('Nicht doch!'), nl, write('Auf dieses Objekt '),
  write('darf nichts gelegt werden.'), nl, !, fail.
belastbar(_).

beweglich(Liste) :-
  unbeweglich(X), element((X, Y), Liste), Y \= ti, 
  write('Aber, aber!'), nl, write('Dieses Objekt '), nl, 
  write('darf nicht bewegt werden.'), nl, !, fail.
beweglich(_).

vertraeglich(Liste) :-
  unvertraeglich(X, Y), element((X, Y), Liste), 
  write('Leider nicht mglich!'), nl, write('Die Objekte '), 
  write('sind nicht miteinander vertrglich.'), nl, !, fail.
vertraeglich(_).

unbeweglich(ti).
unbeweglich(ki).

unbelastbar(ht).

unvertraeglich(gb, ki).

unbestimmt(bu).

/* Prdikate zur Listenverarbeitung */

ersetzt(Alt, Neu, [Alt| Liste], [Neu| Liste]).
ersetzt(Alt, Neu, [K| Altliste], [K| Neuliste]) :-
  ersetzt(Alt, Neu, Altliste, Neuliste).

element(E, [E| _]).
element(E, [_| Rest]) :-
  element(E, Rest).
