                       /* BLW-BED2.PRO */
bw :-
  dialog([(ht, ti), (kb, ki), (gb, ti), (ki, ti), (de, gb)]).

dialog(Zustand) :-
  zeigt(Zustand),  
  ermittelt(Befehlsinhalt),
  ausgefuehrt(Befehlsinhalt, Zustand, Neuzustand), !,
  dialog(Neuzustand).
dialog(_) :-
  nl, write('Dialog beendet. Drcken Sie eine Taste!'),
  nl, get0(_).
  
zeigt(Liste) :-
  write(Liste), nl.
    
ermittelt((Objekt, Ziel)) :-
  write('Geben Sie Objekt und Zielobjekt ein!'), nl,
  write('Objekt (z. B. kb fr "kleines Buch", Ende mit e.)'), nl,
  write('>>> '), read(Objekt), write(Objekt), nl, 
  Objekt \= e, 
  write('Zielobjekt (z. B. ki fr "Kiste", Ende mit e.)'), nl,
  write('>>> '), read(Ziel), write(Ziel), nl,
  Ziel \= e.
  
ausgefuehrt((Obj, Ziel), Liste, Neuliste) :-
  ersetzt((Obj, _), (Obj, Ziel), Liste, Neuliste),
  verschieden(Liste, Neuliste), 
  zulaessig(Neuliste),
  write('Bewegung ausgefhrt.'), nl, nl, !.
ausgefuehrt(_, Liste, Liste) :-
  write('Es wurde keine Bewegung ausgefhrt.'), nl, nl.
    
verschieden(Liste1, Liste2) :-
  Liste1 \= Liste2, !.
verschieden(_, _) :-
  write('Diese Operation bewirkt nichts.'), nl, fail.
  
zulaessig(X) :-
  irreflexiv(X),
  einfachbelegt(X),
  ungestapelt(X),
  belastbar(X),
  beweglich(X),
  vertraeglich(X).

/* Zustandsbedingungen */

irreflexiv(Liste) :-
  element((X, X), Liste), write('Geht nicht!'), nl,
  write('Die Objekte mssen verschieden sein.'), nl, !, fail.
irreflexiv(_).

einfachbelegt(Liste) :-
  element((X, Z), Liste), element((Y, Z), Liste), X \= Y, Z \= ti, 
  write('So nicht!'), nl, write('Zwei Objekte '),
  write('drfen nicht das gleiche Ziel haben.'), nl, !, fail.
einfachbelegt(_).

ungestapelt(Liste) :-
  element((X, Y), Liste), element((Y, Z), Liste), Z \= ti,
  write('Tut mir leid!'), nl, write('Die Objekte '),
  write('drfen nicht gestapelt werden.'), nl, !, fail.
ungestapelt(_).
  
belastbar(Liste) :-
  unbelastbar(X), element((_, X), Liste),  
  write('Nicht doch!'), nl, write('Auf dieses Objekt '),
  write('darf nichts gelegt werden.'), nl, !, fail.
belastbar(_).

beweglich(Liste) :-
  unbeweglich(X), element((X, Y), Liste), Y \= ti, 
  write('Aber, aber!'), nl, write('Dieses Objekt '), nl, 
  write('darf nicht bewegt werden.'), nl, !, fail.
beweglich(_).

vertraeglich(Liste) :-
  unvertraeglich(X, Y), element((X, Y), Liste), 
  write('Leider nicht mglich!'), nl, write('Die Objekte '), 
  write('sind nicht miteinander vertrglich.'), nl, !, fail.
vertraeglich(_).

unbeweglich(ti).
unbeweglich(ki).

unbelastbar(ht).

unvertraeglich(gb, ki).

/* Prdikate zur Listenverarbeitung */

ersetzt(Alt, Neu, [Alt| Liste], [Neu| Liste]).
ersetzt(Alt, Neu, [K| Altliste], [K| Neuliste]) :-
  ersetzt(Alt, Neu, Altliste, Neuliste).

element(E, [E| _]).
element(E, [_| Rest]) :-
  element(E, Rest).
