import javax.sound.midi.*;

public class Akkord {
  // spielt zu jedem Ton Begleitakkord

  static final int motiv[][] =
    // Motiv h-e-a-e-es nach Thomas Mann (Doktor Faustus)
    {{71, 1}, {64, 2}, {69, 1}, {64, 1}, {63, 3}};

  static final int zk1 = 16; // Zeitkonstante (Auflsung)
  static final int zk2 =  5; // Zeitkonstante (Stakkato)

  private static MidiEvent Klang (int modus, int note, 
                           long zeitpunkt) throws Exception {
    ShortMessage nachricht = new ShortMessage();
    if (modus == 1)
      nachricht.setMessage(ShortMessage.NOTE_ON, note, 90);
    else if (modus == 0)
      nachricht.setMessage(ShortMessage.NOTE_OFF, note, 0);
    return new MidiEvent(nachricht, zeitpunkt);
    } // Ende Klang

  public static void main (String[] xy) throws Exception {

    Sequence tonfolge = new Sequence(Sequence.PPQ, zk1);
    Track    tonspur1 = tonfolge.createTrack();
    Track    tonspur2 = tonfolge.createTrack();
    Track    tonspur3 = tonfolge.createTrack();
    long     einsatzzeit = 0; // Einsatzzeitpunkt

    for (int i = 0; i < motiv.length; i++) {
      tonspur1.add(Klang(1, motiv[i][0],     einsatzzeit));
      tonspur2.add(Klang(1, motiv[i][0] + 3, einsatzzeit));
      tonspur3.add(Klang(1, motiv[i][0] + 7, einsatzzeit));
      einsatzzeit = einsatzzeit + zk1 * motiv[i][1] - zk2; 
      tonspur1.add(Klang(0, motiv[i][0],     einsatzzeit));
      tonspur2.add(Klang(0, motiv[i][0] + 3, einsatzzeit));
      tonspur3.add(Klang(0, motiv[i][0] + 7, einsatzzeit));
      einsatzzeit = einsatzzeit + zk2; 
      } // Ende for

    Sequencer abspieler = MidiSystem.getSequencer();
    abspieler.open();
    abspieler.setSequence(tonfolge);
    abspieler.setTempoInBPM(180);

    abspieler.start();
    while(true)
      if (! abspieler.isRunning()) break;

    abspieler.stop();
    abspieler.close();
    System.exit(0);

    } // Ende main
  } // Ende Akkord